{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Tel.: +0351-8012255                   =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 20.01.1998 - 18:00:00 $                                      =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MM3dEdit, MMObj, MMDesign, MM3D, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    MM3DDisplay1: TMM3DDisplay;
    MM3DViewportFrame1: TMM3DViewportFrame;
    MM3DDisplayFrame1: TMM3DDisplayFrame;
    MM3DCameraFrame1: TMM3DCameraFrame;
    MM3DUserFrame1: TMM3DUserFrame;
    Panel1: TPanel;
    MM3DCameraMotion1: TMM3DCameraMotion;
    Button1: TButton;
    Button2: TButton;
    MM3DModelFrame1: TMM3DModelFrame;
    Button3: TButton;
    Button4: TButton;
    procedure MM3DUserFrame1Render(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.MM3DUserFrame1Render(Sender: TObject);
var
    O, V: TMM3DVector;
    M: TMM3DMatrix4D;
    F, T: TMM3DVector;
begin
    with Sender as TMM3DFrame do
    begin
        Vector(MM3DVector(-10,-10,-10),MM3DVector(10,-10,-10));
        Vector(MM3DVector(10,-10,-10),MM3DVector(10,10,-10));
        Vector(MM3DVector(10,10,-10),MM3DVector(-10,10,-10));
        Vector(MM3DVector(-10,10,-10),MM3DVector(-10,-10,-10));
        Vector(MM3DVector(-10,-10,10),MM3DVector(10,-10,10));
        Vector(MM3DVector(10,-10,10),MM3DVector(10,10,10));
        Vector(MM3DVector(10,10,10),MM3DVector(-10,10,10));
        Vector(MM3DVector(-10,10,10),MM3DVector(-10,-10,10));

        CurrentPen.Color := Red;
        Vector(MM3DVector(-10,-10,-10),MM3DVector(-10,-10,10));
        CurrentPen.Color := Green;
        Vector(MM3DVector(-10,10,-10),MM3DVector(-10,10,10));
        CurrentPen.Color := Blue;
        Vector(MM3DVector(10,-10,-10),MM3DVector(10,-10,10));
        CurrentPen.Color := White;
        Vector(MM3DVector(10,10,-10),MM3DVector(10,10,10));

        F := MM3DCameraFrame1.OrientFront.AsVector;
        T := MM3DCameraFrame1.OrientTop.AsVector;

        M := MM3DMatrixFromCameraOrientation(F,T);
        with MM3DVectorTransform(MM3DVectorScale(ZUnit,1000),M) do
        begin
            V.X := X/W;
            V.Y := Y/W;
            V.Z := Z/W;
        end;

        CurrentPen.Width := 5;

        O := MM3DCameraFrame1.Origin.AsVector;

        Vector(O,MM3DVectorAdd(O,V));

//        Caption := Format('%g',[MM3DVectorDotProduct(MM3DCameraFrame1.OrientFront.AsVector,MM3DCameraFrame1.OrientTop.AsVector)]);
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
    F: TextFile;
    S: String;
    i: Integer;
begin
    AssignFile(F,ChangeFileExt(Application.ExeName,'.POS'));
    Rewrite(F);
    try
        with MM3DCameraFrame1 do
        begin
            S := Format('%g %g %g %g %g %g %g %g %g',
                        [Origin.X,Origin.Y,Origin.Z,
                         OrientFront.X,OrientFront.Y,OrientFront.Z,
                         OrientTop.X,OrientTop.Y,OrientTop.Z]);
            while True do
            begin
                i := Pos(DecimalSeparator,S);
                if i = 0 then
                    Break;
                S[i] := '.';
            end;
            Writeln(F,S);
        end;
    finally
        CloseFile(F);
    end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
    F: TextFile;
    Org, Fr, Top: TMM3DVector;
begin
    AssignFile(F,ChangeFileExt(Application.ExeName,'.POS'));
    Reset(F);
    try
        with MM3DCameraFrame1 do
        begin
            Readln(F,Org.X,Org.Y,Org.Z,Fr.X,Fr.Y,Fr.Z,Top.X,Top.Y,Top.Z);
            OrientFront.AsVector := Fr;
            OrientTop.AsVector := Top;
            Origin.AsVector := Org;
        end;
    finally
        CloseFile(F);
    end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
//    MM3DModelFrame1.AddVector(XUnit,YUnit);
//    MM3DModelFrame1.AddVector(YUnit,ZUnit);
//    MM3DModelFrame1.AddVector(ZUnit,XUnit);
    MM3DModelFrame1.InText := True;
    MM3DModelFrame1.SaveToFile('sample.txt');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
    MM3DModelFrame1.InText := True;
    MM3DModelFrame1.LoadFromFile('sample2.txt');
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    MM3DCameraMotion1.KeyDown(Key,Shift);
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
begin
    MM3DCameraMotion1.KeyPress(Key);
end;

end.

